---
title: Status codes - Custom hostnames · Cloudflare for Platforms docs
lastUpdated: 2025-07-31T16:16:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/reference/status-codes/custom-hostnames/
  md: https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/reference/status-codes/custom-hostnames/index.md
---

***

## Success codes

| Endpoint | Method | Code |
| - | - | - |
| `/v4/zones/:zone_id/custom_hostnames` | POST | 201 Created |
| `/v4/zones/:zone_id/custom_hostnames/:custom_hostname_id` | GET | 200 OK |
| `/v4/zones/:zone_id/custom_hostnames` | GET | 200 OK |
| `/v4/zones/:zone_id/custom_hostnames/:custom_hostname_id` | DELETE | 200 OK |
| `/v4/zones/:zone_id/custom_hostnames/:custom_hostname_id` | PATCH | 202 Accepted |

***

## Error codes

| HTTP Status Code | API Error Code | Error Message |
| - | - | - |
| 400 | 1400 | Unable to decode the JSON request body. Check your input and try again. |
| 400 | 1401 | Unable to encode the Custom Metadata as JSON. Check your input and try again. |
| 400 | 1402 | Zone ID is required. Check your input and try again. |
| 400 | 1403 | The request has no Authorization header. Check your input and try again. |
| 400 | 1407 | Invalid custom hostname. Custom hostnames have to be smaller than 256 characters in length, cannot be IP addresses, cannot contain any special characters such as \`\`\~\`!@#$%^&\*()=+\[]\\ |
| 400 | 1408 | Custom hostnames with non-ASCII characters are not supported. Check your input and try again. |
| 400 | 1409 | Reserved top domain custom hostnames, such as 'test', 'example', 'invalid' or 'localhost', is not supported. Check your input and try again. |
| 400 | 1410 | Unable to parse custom hostname - `:reason`. Check your input and try again. **Reasons:** publicsuffix: cannot derive eTLD+1 for domain `:domain` publicsuffix: invalid public suffix `:suffix` for domain `:domain` |
| 400 | 1411 | Custom hostnames ending in example.com, example.net, or example.org are prohibited. Check your input and try again. |
| 400 | 1412 | Custom metadata for wildcard custom hostnames is not supported. Check your input and try again. **Note:** This message is only presented to customers who have opted out of wildcard support for custom metadata. |
| 400 | 1415 | Invalid custom origin hostname. Custom origin hostnames have to be smaller than 256 characters in length, cannot be IP addresses, cannot contain any special characters such as \`!@#$%^&\*()=+\[]\\ |
| 400 | 1416 | Custom origin hostnames with non-ASCII characters are not supported. Check your input and try again. |
| 400 | 1417 | Reserved top domain custom origin hostnames, such as 'test', 'example', 'invalid' or 'localhost', is not supported. Check your input and try again. |
| 400 | 1418 | Unable to parse custom origin hostname - `:reason`. Check your input and try again. **Reasons:** publicsuffix: cannot derive eTLD+1 for domain `:domain` publicsuffix: invalid public suffix`:suffix`for domain`:domain` |
| 400 | 1419 | Custom origin hostnames ending in example.com, example.net, or example.org are prohibited. Check your input and try again. |
| 400 | 1420 | Wildcard custom origin hostnames are not supported. Check your input and try again. |
| 400 | 1421 | The custom origin hostname you specified does not exist on Cloudflare as a DNS record (A, AAAA or CNAME) in your zone:`:zone\_tag`. Check your input and try again. |
| 400 | 1422 | Invalid `http2`setting. Only 'on' or 'off' is accepted. Check your input and try again. |
| 400 | 1423 | Invalid`tls\_1\_2\_only`setting. Only 'on' or 'off' is accepted. Check your input and try again. |
| 400 | 1424 | Invalid`tls\_1\_3`setting. Only 'on' or 'off' is accepted. Check your input and try again. |
| 400 | 1425 | Invalid`min\_tls\_version`setting. Only '1.0','1.1','1.2' or '1.3' is accepted. Check your input and try again. |
| 400 | 1426 | The certificate that you uploaded cannot be parsed. Check your input and try again. |
| 400 | 1427 | The certificate that you uploaded is empty. Check your input and try again. |
| 400 | 1428 | The private key you uploaded cannot be parsed. Check your input and try again. |
| 400 | 1429 | The private key you uploaded does not match the certificate. Check your input and try again. |
| 400 | 1430 | The custom CSR ID is invalid. Check your input and try again. |
| 404 | 1431 | The custom CSR was not found. |
| 400 | 1432 | The validation method is not supported. Only`http`, `email`, or `txt` are accepted. Check your input and try again. |
| 400 | 1433 | The validation type is not supported. Only 'dv' is accepted. Check your input and try again. |
| 400 | 1434 | The SSL attribute is invalid. Refer to the API documentation, check your input and try again. |
| 400 | 1435 | The custom hostname ID is invalid. Check your input and try again. |
| 404 | 1436 | The custom hostname was not found. |
| 400 | 1437 | Invalid hostname.contain query parameter. The hostname.contain query parameter has to be smaller than 256 characters in length, cannot be IP addresses, cannot contain any special characters such as \`\`\~\`!@#$%^&\*()=+\[]\\ |
| 400 | 1438 | Cannot specify other filter parameters in addition to `id`. Only one must be specified. Check your input and try again. |
| 409 | 1439 | Modifying the custom hostname is not supported. Check your input and try again. |
| 400 | 1440 | Both validation type and validation method are required. Check your input and try again. |
| 400 | 1441 | The certificate that you uploaded is having trouble bundling against the public trust store. Check your input and try again. |
| 400 | 1442 | Invalid `ciphers` setting. Refer to the documentation for the list of accepted cipher suites. Check your input and try again. |
| 400 | 1443 | Cipher suite selection is not supported for a minimum TLS version of 1.3. Check your input and try again. |
| 400 | 1444 | The certificate chain that you uploaded has multiple leaf certificates. Check your input and try again. |
| 400 | 1445 | The certificate chain that you uploaded has no leaf certificates. Check your input and try again. |
| 400 | 1446 | The certificate that you uploaded does not include the custom hostname - `:custom_hostname`. Review your input and try again. |
| 400 | 1447 | The certificate that you uploaded does not use a supported signature algorithm. Only SHA-256/ECDSA, SHA-256/RSA, and SHA-1/RSA signature algorithms are supported. Review your input and try again. |
| 400 | 1448 | Custom hostnames with wildcards are not supported for certificates managed by Cloudflare. Review your input and try again. |
| 400 | 1449 | The request input `bundle_method` must be one of: ubiquitous, optimal, force. |
| 401 | 1000 | Unable to extract bearer token |
| 401 | 1001 | Unable to parse JWT token |
| 401 | 1002 | Bad JWT header |
| 401 | 1003 | Failed to verify JWT token |
| 401 | 1004 | Failed to get claims from JWT token |
| 401 | 1005 | JWT token does not have required claims |
| 403 | 1404 | No quota has been allocated for this zone. If you are already a paid Cloudflare for SaaS customer, contact your Customer Success Manager for additional provisioning. If you are not yet enrolled, [fill out this contact form](https://www.cloudflare.com/plans/enterprise/contact/) and our sales team will reach out to you. |
| 403 | 1405 | Quota exceeded. If you are already a paid Cloudflare for SaaS customer, contact your Customer Success Manager for additional provisioning. If you are not yet enrolled, [fill out this contact form](https://www.cloudflare.com/plans/enterprise/contact/) and our sales team will reach out to you. |
| 403 | 1413 | No [custom metadata](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/custom-metadata/) access has been allocated for this zone. If you are already a paid customer, contact your Customer Success Manager for additional provisioning. If you are not yet enrolled, [fill out this contact form](https://www.cloudflare.com/plans/enterprise/contact/) and our sales team will reach out to you. |
| 403 | 1414 | Access to setting a custom origin server has not been granted for this zone. If you are already a paid Cloudflare for SaaS customer, contact your Customer Success Manager for additional provisioning. If you are not yet enrolled, [fill out this contact form](https://www.cloudflare.com/plans/enterprise/contact/) and our sales team will reach out to you. |
| 409 | 1406 | Duplicate custom hostname found. |
| 500 | 1500 | Internal Server Error |
