---
title: File types and extensions · Cloudflare Style Guide
description: "You can refer both to file types and file extensions in documentation:"
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/formatting/file-types-and-extensions/
  md: https://developers.cloudflare.com/style-guide/formatting/file-types-and-extensions/index.md
---

You can refer both to file types and file extensions in documentation:

* File types: Accepted file formats are JSON and YAML.
* File extensions: Upload the `.txt` file to the dashboard.

When referring to a specific file type, always use regular text formatting, write the file type in uppercase, and avoid the initial dot (you are referring to the file type, not the file extension).

When referring to a specific extension, always monospace the file, include a dot, write the extension in lowercase, and always specify a noun after mentioning a file extension (for example: "file" or "file extension"). Do not leave the extension hanging.

Additional examples:

* The accepted file formats are YAML (files with a `.yml` or `.yaml` file extension) and JSON (files with a `.json` file extension).
* Additionally, this plist can be wrapped in a `.mobileconfig` file.
* If you would like to test how this feature works, here is a sample `.csv` file.
* Concatenate the string to a text-based `.pem` file.
